/* --------------------------------------------------------------
  Title.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

/**
 * Title Widget
 *
 * This widget will display a plain sub-category title as part of the settings list.
 */
export default class Title {
	/**
	 * Class Constructor 
	 * 
	 * @param {Setting} entity Contains the setting information.
	 */
	constructor(entity) {
		StyleEdit.Validator.isObject(entity);
		
		/**
		 * @type {Setting}
		 */
		this.entity = entity;
	}
	
	/**
	 * Initialize the widget.
	 */
	initialize() {
		// Nothing to do ...
	}
	
	/**
	 * Get Widget HTML
	 *
	 * @return {String}
	 */
	getHtml() {
		const template = $('#widget-title-template').html();
		const data = {
			title: StyleEdit.Language.translate(this.entity.getName(), 'template')
		};
		return Mustache.render(template, data);
	}
}
